<?php
// Extendable Child - Styles + Anti-redirection

// Charge styles parent
function extendable_child_enqueue_styles() {
    wp_enqueue_style('parent-style', get_template_directory_uri() . '/style.css');
    wp_enqueue_style('child-style', get_stylesheet_uri(), array('parent-style'), wp_get_theme()->get('Version'));
}
add_action('wp_enqueue_scripts', 'extendable_child_enqueue_styles', 11);

// Anti-redirection liste après confirm
add_action('wp_footer', function() {
    if (is_page() && has_shortcode(get_post()->post_content, 'motopress-hotel-booking')) { ?>
        <script>
        jQuery(document).ready(function($){
            $('.mphb-booking-confirm-button').on('click', function(){
                setTimeout(function(){
                    if (window.location.hash.includes('booking-form')) {
                        window.history.back();
                    }
                }, 1500);
            });
        });
        </script>
        <?php
    }
});
?>
