<?php
/**
 * Internationalization file.
 *
 * Define the internationalization functionality.
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @link       http://codeamp.com
 * @since      1.0.0
 *
 * @package    Custom_Layouts
 * @subpackage Custom_Layouts/includes
 */

namespace Custom_Layouts\Core;

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Internationalization class.
 *
 * Handles loading the plugin text domain for translation.
 *
 * @since 1.0.0
 */
// phpcs:ignore WordPress.NamingConventions.ValidClassName.NotCamelCaps -- Class name preserved for backward compatibility.
class i18n {


	/**
	 * Load the plugin text domain for translation.
	 *
	 * @since    1.0.0
	 * @return void
	 */
	public function load_plugin_textdomain() {

		load_plugin_textdomain(
			'custom-layouts',
			false,
			dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/'
		);
	}
}
